DROP TRIGGER EESRV.SERV_REQUEST_ASSIGN_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER EESRV.SERV_REQUEST_ASSIGN_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.SERVICE_REQUEST_ASSIGNMENT
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into SERVICE_REQUEST_ASSIGNMENT_H
        (
        SERVICE_REQ_ASSIGN_H_ID,
        SERVICE_REQUEST_ASSIGNMENT_ID,
        SERVICE_REQUEST_ID,
        SERVICE_USER_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        SERVICE_REQUEST_ASSIGNMENT_H_S.nextval,
        :old.SERVICE_REQUEST_ASSIGNMENT_ID,
        :old.SERVICE_REQUEST_ID,
        :old.SERVICE_USER_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into SERVICE_REQUEST_ASSIGNMENT_H
        (
        SERVICE_REQ_ASSIGN_H_ID,
        SERVICE_REQUEST_ASSIGNMENT_ID,
        SERVICE_REQUEST_ID,
        SERVICE_USER_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        SERVICE_REQUEST_ASSIGNMENT_H_S.nextval,
        :new.SERVICE_REQUEST_ASSIGNMENT_ID,
        :new.SERVICE_REQUEST_ID,
        :new.SERVICE_USER_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end SERV_REQUEST_ASSIGN_AUDIR_TRGR;
/
DROP TRIGGER EESRV.SERVICE_USER_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER EESRV.SERVICE_USER_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.SERVICE_USER
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into SERVICE_USER_H
        (
        SERVICE_USER_H_ID,
        SERVICE_USER_ID,
        USERNAME,
        PASSWORD,
        ACTIVE_FLAG,
        CONTACT_NAME,
        CONTACT_PHONE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        SERVICE_USER_H_S.nextval,
        :old.SERVICE_USER_ID,
        :old.USERNAME,
        :old.PASSWORD,
        :old.ACTIVE_FLAG,
        :old.CONTACT_NAME,
        :old.CONTACT_PHONE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into SERVICE_USER_H
        (
        SERVICE_USER_H_ID,
        SERVICE_USER_ID,
        USERNAME,
        PASSWORD,
        ACTIVE_FLAG,
        CONTACT_NAME,
        CONTACT_PHONE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        SERVICE_USER_H_S.nextval,
        :new.SERVICE_USER_ID,
        :new.USERNAME,
       :new.PASSWORD,
       :new.ACTIVE_FLAG,
       :new.CONTACT_NAME,
       :new.CONTACT_PHONE,
       :new.RECORD_CREATED_BY,
       :new.RECORD_CREATED_DATE,
      :new.RECORD_MODIFIED_BY,
       :new.RECORD_MODIFIED_DATE,
       :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end SERVICE_USER_audir_trgr;
/
DROP TRIGGER EESRV.SERVICE_REQUEST_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER EESRV.SERVICE_REQUEST_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.SERVICE_REQUEST
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into SERVICE_REQUEST_H
        (
        SERVICE_REQUEST_H_ID,
        SERVICE_REQUEST_ID,
        NAME,
        DESCRIPTION,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        SERVICE_REQUEST_H_S.nextval,
        :old.SERVICE_REQUEST_ID,
        :old.NAME,
        :old.DESCRIPTION,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into SERVICE_REQUEST_H
        (
        SERVICE_REQUEST_H_ID,
        SERVICE_REQUEST_ID,
        NAME,
        DESCRIPTION,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        SERVICE_REQUEST_H_S.nextval,
        :new.SERVICE_REQUEST_ID,
        :new.NAME,
        :new.DESCRIPTION,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end SERVICE_REQUEST_audir_trgr;
/
DROP TRIGGER EESRV.REQUEST_GROUP_TRGR;

CREATE OR REPLACE TRIGGER EESRV.REQUEST_GROUP_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.REQUEST_GROUP
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into REQUEST_GROUP_H
        (
        REQUEST_GROUP_H_ID,
        REQUEST_GROUP_ID,
        SERVICE_REQUEST_ID,
        FIELD_GROUP_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        REQUEST_GROUP_H_S.nextval,
        :old.REQUEST_GROUP_ID,
        :old.SERVICE_REQUEST_ID,
        :old.FIELD_GROUP_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into REQUEST_GROUP_H
        (
        REQUEST_GROUP_H_ID,
        REQUEST_GROUP_ID,
        SERVICE_REQUEST_ID,
        FIELD_GROUP_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        REQUEST_GROUP_H_S.nextval,
        :new.REQUEST_GROUP_ID,
        :new.SERVICE_REQUEST_ID,
        :new.FIELD_GROUP_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end REQUEST_GROUP_TRGR;
/
DROP TRIGGER EESRV.REQUEST_FIELD_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER EESRV.REQUEST_FIELD_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.REQUEST_FIELD
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into REQUEST_FIELD_H
        (
        REQUEST_FIELD_H_ID,
        REQUEST_FIELD_ID,
        FIELD_ID,
        SERVICE_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
          )
        values
        (
        REQUEST_FIELD_H_S.nextval,
        :old.REQUEST_FIELD_ID,
        :old.FIELD_ID,
        :old.SERVICE_REQUEST_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into REQUEST_FIELD_H
        (
        REQUEST_FIELD_H_ID,
        REQUEST_FIELD_ID,
        FIELD_ID,
        SERVICE_REQUEST_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        REQUEST_FIELD_H_S.nextval,
        :new.REQUEST_FIELD_ID,
        :new.FIELD_ID,
        :new.SERVICE_REQUEST_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end REQUEST_FIELD_audir_trgr;
/
DROP TRIGGER EESRV.FIELD_GROUP_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER EESRV.FIELD_GROUP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.FIELD_GROUP
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into FIELD_GROUP_H
        (
        FIELD_GROUP_H_ID,
        FIELD_GROUP_ID,
        PARENT_GROUP_ID,
        NAME,
        DESCRIPTION,
        DEFAULT_GROUP_FLAG,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        FIELD_GROUP_H_S.nextval,
        :old.FIELD_GROUP_ID,
        :old.PARENT_GROUP_ID,
        :old.NAME,
        :old.DESCRIPTION,
        :old.DEFAULT_GROUP_FLAG,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into FIELD_GROUP_H
        (
        FIELD_GROUP_H_ID,
        FIELD_GROUP_ID,
        PARENT_GROUP_ID,
        NAME,
        DESCRIPTION,
        DEFAULT_GROUP_FLAG,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
          )
        values
        (
        FIELD_GROUP_H_S.nextval,
        :new.FIELD_GROUP_ID,
        :new.PARENT_GROUP_ID,
        :new.NAME,
        :new.DESCRIPTION,
        :new.DEFAULT_GROUP_FLAG,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end FIELD_GROUP_audir_trgr;
/
DROP TRIGGER EESRV.FIELD_AUDIR_TRGR;

CREATE OR REPLACE TRIGGER EESRV.FIELD_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON EESRV.FIELD
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into FIELD_H
        (
        FIELD_H_ID,
        FIELD_ID,
        FIELD_GROUP_ID,
        NAME,
        DESCRIPTION,
        DEFAULT_FIELD_FLAG,
        TABLE_NAME,
        COLUMN_NAME,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        FIELD_H_S.nextval,
        :old.FIELD_ID,
        :old.FIELD_GROUP_ID,
        :old.NAME,
        :old.DESCRIPTION,
        :old.DEFAULT_FIELD_FLAG,
        :old.TABLE_NAME,
        :old.COLUMN_NAME,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into FIELD_H
        (
        FIELD_H_ID,
        FIELD_ID,
        FIELD_GROUP_ID,
        NAME,
        DESCRIPTION,
        DEFAULT_FIELD_FLAG,
        TABLE_NAME,
        COLUMN_NAME,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        FIELD_H_S.nextval,
        :new.FIELD_ID,
        :new.FIELD_GROUP_ID,
        :new.NAME,
        :new.DESCRIPTION,
        :new.DEFAULT_FIELD_FLAG,
        :new.TABLE_NAME,
        :new.COLUMN_NAME,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end FIELD_audir_trgr;
/
